//
//  KSGDT_SplasshAdDelegateObject.m
//  GDTMobApp
//
//  Created by Nancy on 2021/1/15.
//  Copyright © 2021 Tencent. All rights reserved.
//

#import "KSGDT_SplasshAdDelegateObject.h"

@implementation KSGDT_SplasshAdDelegateObject

#pragma mark - KSAdSplashInteractDelegate

/**
 * 闪屏广告展示
 */
- (void)ksad_splashAdDidShow {
    [self.connector adapter_splashAdExposured:self.adapter];
}

/**
 * 闪屏广告点击转化
 */
- (void)ksad_splashAdClicked {
    [self.connector adapter_splashAdClicked:self.adapter];
}

/**
 * 视频闪屏广告开始播放
 */
- (void)ksad_splashAdVideoDidStartPlay {
    
}

/**
 * 视频闪屏广告播放失败
 */
- (void)ksad_splashAdVideoFailedToPlay:(NSError *)error {
    
}

/**
 * 视频闪屏广告跳过
 */
- (void)ksad_splashAdVideoDidSkipped:(NSTimeInterval)playDuration {
    
}

/**
 * 闪屏广告关闭，需要在这个方法里关闭闪屏页面
 * @param converted      是否转化
 */
- (void)ksad_splashAdDismiss:(BOOL)converted {
    if (converted) {
        if ([[self ksad_splashAdConversionRootVC].presentedViewController isKindOfClass:[KSAdSplashViewController class]]) {
            [[self ksad_splashAdConversionRootVC] dismissViewControllerAnimated:YES completion:nil
             ];
        }
    }
    
}

/**
 * 转化控制器容器，如果未实现则默认闪屏页面的上级控制器
 */
- (UIViewController *)ksad_splashAdConversionRootVC {
    return [UIApplication sharedApplication].keyWindow.rootViewController;
}

@end
