//
//  BUGDT_UnifiedInterstitialAdAdapter.m
//  GDTMobApp
//
//  Created by royqpwang on 2019/8/10.
//  Copyright © 2019 Tencent. All rights reserved.
//

#import "BUGDT_UnifiedInterstitialAdAdapter.h"
#import <BUAdSDK/BUAdSDK.h>
#import "GDTUnifiedInterstitialAdNetworkConnectorProtocol.h"
#import "MediationAdapterUtil.h"
#import "BUGDT_UnifiedInterstitialAdDelegateObject.h"

@interface BUGDT_UnifiedInterstitialAdAdapter () 

@property (nonatomic, weak) id <GDTUnifiedInterstitialAdNetworkConnectorProtocol>connector;
@property (nonatomic, strong) BUInterstitialAd *interstitialAd;
@property (nonatomic, strong) BUFullscreenVideoAd *fullscreenAd;
@property (nonatomic, copy) NSString *slotID;
@property (nonatomic, strong) BUGDT_UnifiedInterstitialAdDelegateObject *delegateObject;

@end

@implementation BUGDT_UnifiedInterstitialAdAdapter
@synthesize shouldLoadFullscreenAd;
@synthesize shouldShowFullscreenAd;

+ (void)updateAppId:(NSString *)appId extStr:(NSString *)extStr {
    if (BUAdSDKManager.appID.length == 0) {
        if ([appId length] > 0) {
            [BUAdSDKManager setAppID:appId];
        }
        else {
            NSDictionary *params = [MediationAdapterUtil getURLParams:extStr];
            [BUAdSDKManager setAppID:params[@"appid"]];
        }
    }
}

- (nullable instancetype)initWithAdNetworkConnector:(nonnull id<GDTUnifiedInterstitialAdNetworkConnectorProtocol>)connector
                                              posId:(nonnull NSString *)posId {
    if (!connector) {
        return nil;
    }
    
    self = [super init];
    if (self) {
        self.connector = connector;
        self.slotID = posId;
    }
    
    return self;
}

- (void)loadAd {
    self.delegateObject = [[BUGDT_UnifiedInterstitialAdDelegateObject alloc] init];
    self.delegateObject.adapter = self;
    self.delegateObject.connector = self.connector;
    
    if (self.shouldLoadFullscreenAd) {
        self.fullscreenAd = [[BUFullscreenVideoAd alloc] initWithSlotID:self.slotID];
        self.fullscreenAd.delegate = self.delegateObject;
        [self.fullscreenAd loadAdData];
    }
    else {
        BUSize *size = [BUSize new];
        size.width = 300;
        size.height = 300;
        self.interstitialAd = [[BUInterstitialAd alloc] initWithSlotID:self.slotID size:size];
        self.interstitialAd.delegate = self.delegateObject;
        [self.interstitialAd loadAdData];
    }
}

- (void)presentAdFromRootViewController:(UIViewController *)rootViewController
{
    if (self.shouldShowFullscreenAd) {
        [self.fullscreenAd showAdFromRootViewController:rootViewController];
    }
    else {
        [self.interstitialAd showAdFromRootViewController:rootViewController];
    }
}

- (BOOL)isAdValid {
    if (self.interstitialAd) {
        return [self.interstitialAd isAdValid];
    }
    else {
        return self.delegateObject.fullscreenAdDidLoad;
    }
}

@end
