//
//  BUGDT_NativeExpressInterstitialAdDelegateObject.m
//  GDTMobApp
//
//  Created by zhangzilong on 2021/4/28.
//  Copyright © 2021 Tencent. All rights reserved.
//

#import "BUGDT_NativeExpressInterstitialAdDelegateObject.h"

@implementation BUGDT_NativeExpressInterstitialAdDelegateObject

#pragma mark - BUNativeExpresInterstitialAdDelegate

- (void)nativeExpresInterstitialAdDidLoad:(BUNativeExpressInterstitialAd *)interstitialAd {
    [self.connector adapter_unifiedInterstitialSuccessToLoadAd:self.adapter];
}

/**
 This method is called when interstitial ad material failed to load.
 @param error : the reason of error
 */
- (void)nativeExpresInterstitialAd:(BUNativeExpressInterstitialAd *)interstitialAd didFailWithError:(NSError * _Nullable)error {
    [self.connector adapter_unifiedInterstitialFailToLoadAd:self.adapter error:error];
}

/**
 This method is called when interstitial ad slot will be showing.
 */
- (void)nativeExpresInterstitialAdWillVisible:(BUNativeExpressInterstitialAd *)interstitialAd {
    [self.connector adapter_unifiedInterstitialWillExposure:self.adapter];
}

/**
 This method is called when interstitial ad is clicked.
 */
- (void)nativeExpresInterstitialAdDidClick:(BUNativeExpressInterstitialAd *)interstitialAd {
    [self.connector adapter_unifiedInterstitialClicked:self.adapter];
}

#pragma mark BUNativeExpresFullscreenVideoAdDelegate

- (void)nativeExpressFullscreenVideoAdDidLoad:(BUNativeExpressFullscreenVideoAd *)fullscreenVideoAd {
    self.fullscreenAdDidLoad = YES;
    [self.connector adapter_unifiedInterstitialSuccessToLoadAd:self.adapter];
}

- (void)nativeExpressFullscreenVideoAd:(BUNativeExpressFullscreenVideoAd *)fullscreenVideoAd didFailWithError:(NSError *)error {
    [self.connector adapter_unifiedInterstitialFailToLoadAd:self.adapter error:error];
}


- (void)nativeExpressFullscreenVideoAdDidClick:(BUNativeExpressFullscreenVideoAd *)fullscreenVideoAd {
    [self.connector adapter_unifiedInterstitialClicked:self.adapter];
}

- (void)nativeExpressFullscreenVideoAdDidClose:(BUNativeExpressFullscreenVideoAd *)fullscreenVideoAd {
    [self.connector adapter_unifiedInterstitialDidDismissScreen:self.adapter];
}


- (void)nativeExpressFullscreenVideoAdWillVisible:(BUNativeExpressFullscreenVideoAd *)fullscreenVideoAd{
    [self.connector adapter_unifiedInterstitialWillExposure:self.adapter];
}

@end
