//
//  BUGDT_NativeExpressInterstitialAdAdapter.m
//  GDTMobApp
//
//  Created by zhangzilong on 2021/4/28.
//  Copyright © 2021 Tencent. All rights reserved.
//

#import "BUGDT_NativeExpressInterstitialAdAdapter.h"
#import <BUAdSDK/BUAdSDK.h>
#import "GDTUnifiedInterstitialAdNetworkConnectorProtocol.h"
#import "MediationAdapterUtil.h"
#import "BUGDT_NativeExpressInterstitialAdDelegateObject.h"

@interface BUGDT_NativeExpressInterstitialAdAdapter ()

@property (nonatomic, weak) id<GDTUnifiedInterstitialAdNetworkConnectorProtocol> connector;
@property (nonatomic, strong) BUNativeExpressInterstitialAd *interstitialAd;
@property (nonatomic, strong) BUNativeExpressFullscreenVideoAd *fullscreenAd;
@property (nonatomic, copy) NSString *slotID;
@property (nonatomic, strong) BUGDT_NativeExpressInterstitialAdDelegateObject *delegateObject;

@end

@implementation BUGDT_NativeExpressInterstitialAdAdapter

@synthesize shouldLoadFullscreenAd;
@synthesize shouldShowFullscreenAd;

+ (void)updateAppId:(NSString *)appId extStr:(NSString *)extStr {
    if (BUAdSDKManager.appID.length == 0) {
        if ([appId length] > 0) {
            [BUAdSDKManager setAppID:appId];
        }
        else {
            NSDictionary *params = [MediationAdapterUtil getURLParams:extStr];
            [BUAdSDKManager setAppID:params[@"appid"]];
        }
    }
}

- (nullable instancetype)initWithAdNetworkConnector:(nonnull id<GDTUnifiedInterstitialAdNetworkConnectorProtocol>)connector
                                              posId:(nonnull NSString *)posId {
    if (!connector) {
        return nil;
    }
    
    self = [super init];
    if (self) {
        self.connector = connector;
        self.slotID = posId;
    }
    
    return self;
}

- (void)loadAd {
    self.delegateObject = [[BUGDT_NativeExpressInterstitialAdDelegateObject alloc] init];
    self.delegateObject.adapter = self;
    self.delegateObject.connector = self.connector;
    
    if (self.shouldLoadFullscreenAd) {
        self.fullscreenAd = [[BUNativeExpressFullscreenVideoAd alloc] initWithSlotID:self.slotID];
        self.fullscreenAd.delegate = self.delegateObject;
        [self.fullscreenAd loadAdData];
    }
    else {
        self.interstitialAd = [[BUNativeExpressInterstitialAd alloc] initWithSlotID:self.slotID adSize:CGSizeMake(300, 300)];
        self.interstitialAd.delegate = self.delegateObject;
        [self.interstitialAd loadAdData];
    }
}

- (void)presentAdFromRootViewController:(UIViewController *)rootViewController
{
    if (self.shouldShowFullscreenAd) {
        [self.fullscreenAd showAdFromRootViewController:rootViewController];
    }
    else {
        [self.interstitialAd showAdFromRootViewController:rootViewController];
    }
}

- (BOOL)isAdValid {
    if (self.interstitialAd) {
        return [self.interstitialAd isAdValid];
    }
    else {
        return self.delegateObject.fullscreenAdDidLoad;
    }
}

@end
